/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.cache;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.lopymine.mtd.api.MojangAPI;
import net.lopymine.mtd.api.Response;
import net.lopymine.mtd.client.MyTotemDollClient;
import net.lopymine.mtd.client.command.reload.ReloadAction;
import net.lopymine.mtd.utils.SkinTextures;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedSkinsManager {
    public static final String MINECRAFT_NICKNAME_REGEX = "^[a-zA-Z0-9_]{2,16}$";
    public static final SkinTextures DEFAULT_DOLL_TEXTURES = new SkinTextures(class_2960.method_43902((String)"minecraft", (String)"textures/entity/player/wide/steve.png"), null, null, null, SkinTextures.Model.WIDE, true);
    private static final Map<String, SkinTextures> CACHE = new ConcurrentHashMap<String, SkinTextures>();
    private static final Set<String> PLAYER_LOADING_SKINS = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final int MAX_LOADING_SKINS = 10;
    private static int loadingSkins = 0;
    private static long lastRequestTime = 0L;

    private static CompletableFuture<Void> loadSkin(String nickname, boolean skipMaxRequestsCheck) {
        if (!skipMaxRequestsCheck) {
            long now = System.currentTimeMillis();
            if (now - lastRequestTime > 1000L) {
                loadingSkins = 0;
                lastRequestTime = now;
            }
            if (loadingSkins >= 10) {
                return CompletableFuture.completedFuture(null);
            }
            ++loadingSkins;
            if (!PLAYER_LOADING_SKINS.add(nickname)) {
                return CompletableFuture.completedFuture(null);
            }
        }
        return CompletableFuture.runAsync(() -> {
            try {
                Response<SkinTextures> response;
                long waitMs = 1000L;
                while ((response = MojangAPI.getSkinTextures(nickname)).isEmpty() && response.statusCode() == 429) {
                    Thread.sleep(waitMs);
                    waitMs += 350L;
                }
                if (!response.isEmpty()) {
                    SkinTextures skinTextures = response.value();
                    CACHE.put(nickname.toLowerCase(), skinTextures);
                }
            }
            catch (Exception e) {
                MyTotemDollClient.LOGGER.error("Failed to load skin for {}:", (Object)nickname, (Object)e);
            }
            finally {
                PLAYER_LOADING_SKINS.remove(nickname);
            }
        });
    }

    @NotNull
    public static SkinTextures getSkin(@NotNull String nickname) {
        if (!nickname.matches(MINECRAFT_NICKNAME_REGEX)) {
            return DEFAULT_DOLL_TEXTURES;
        }
        SkinTextures skinTextures = CACHE.get(nickname.toLowerCase());
        if (skinTextures == null) {
            CachedSkinsManager.loadSkin(nickname, false);
            return DEFAULT_DOLL_TEXTURES;
        }
        return skinTextures;
    }

    public static Set<String> getLoadedPlayers() {
        return CACHE.keySet();
    }

    public static void reload(ReloadAction action) {
        HashSet<CompletableFuture<Void>> list = new HashSet<CompletableFuture<Void>>();
        long startMs = System.currentTimeMillis();
        Set<Map.Entry<String, SkinTextures>> entries = CACHE.entrySet();
        for (Map.Entry<String, SkinTextures> entry : entries) {
            String nickname = entry.getKey();
            SkinTextures skinTextures = entry.getValue();
            CACHE.put(nickname.toLowerCase(), DEFAULT_DOLL_TEXTURES);
            CachedSkinsManager.destroyTexture(skinTextures);
            list.add(CachedSkinsManager.loadSkin(nickname, true));
        }
        CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).thenApply(__ -> {
            action.action((float)(System.currentTimeMillis() - startMs) / 1000.0f);
            return null;
        });
    }

    private static void destroyTexture(@Nullable SkinTextures skinTextures) {
        if (skinTextures != null) {
            if (skinTextures.equals(DEFAULT_DOLL_TEXTURES)) {
                return;
            }
            class_1060 textureManager = class_310.method_1551().method_1531();
            textureManager.method_4615(skinTextures.texture());
            if (skinTextures.capeTexture() != null) {
                textureManager.method_4615(skinTextures.capeTexture());
            }
        }
    }

    public static void reload(String nickname, ReloadAction action) {
        long startMs = System.currentTimeMillis();
        CompletableFuture.runAsync(() -> {
            SkinTextures skinTextures = CACHE.get(nickname);
            CACHE.put(nickname.toLowerCase(), DEFAULT_DOLL_TEXTURES);
            CachedSkinsManager.destroyTexture(skinTextures);
            CachedSkinsManager.loadSkin(nickname, true).thenApply(__ -> {
                action.action((float)(System.currentTimeMillis() - startMs) / 1000.0f);
                return null;
            });
        });
    }
}

